/****** Object:  Trigger [TRG_EST_PROD_CPL_ACERTO_CUSTO_PROCESSAMENTO_PENDENTE]    Script Date: 30/04/15 11:46:53 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_PROD_CPL_ACERTO_CUSTO_PROCESSAMENTO_PENDENTE_EXCLUSAO]'))
DROP TRIGGER [dbo].[TRG_EST_PROD_CPL_ACERTO_CUSTO_PROCESSAMENTO_PENDENTE_EXCLUSAO]
GO
GO
GO

/****** Object:  Trigger [dbo].[TRG_EST_PROD_CPL_ACERTO_CUSTO_PROCESSAMENTO_PENDENTE]    Script Date: 03/09/2015 19:57:10 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER [dbo].[TRG_EST_PROD_CPL_ACERTO_CUSTO_PROCESSAMENTO_PENDENTE_EXCLUSAO] ON [dbo].[EST_PROD_CPL_ACERTO_CUSTO] 
FOR DELETE
AS

IF NOT EXISTS(SELECT
				p.CD_EMP
			  FROM
				EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p INNER JOIN DELETED i ON
				p.CD_EMP = i.CD_EMP AND
				p.CD_FILIAL = i.CD_FILIAL AND
				p.CD_PROD = i.CD_PROD)
begin
	INSERT INTO EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE
	  (CD_EMP,
	  CD_FILIAL,
	  CD_PROD,
	  DT_PROC,
	  DT_CAD,
	  DT_PROC_ATUAL)
	SELECT
		i.CD_EMP,
		i.CD_FILIAL,
		i.CD_PROD,
		MIN(i.DT_MOV),
		GETDATE(),
		NULL
	FROM
		DELETED i 
	GROUP BY
		i.CD_EMP,
		i.CD_FILIAL,
		i.CD_PROD
end
ELSE
begin
	UPDATE
		p
	SET 
		p.DT_PROC=i.DT_MOV,
		p.DT_CAD=GETDATE()
	FROM
		EST_PROD_CPL_CUSTO_MEDIO_PROCESSAMENTO_PENDENTE p INNER JOIN DELETED i ON
		p.CD_EMP = i.CD_EMP AND
		p.CD_FILIAL = i.CD_FILIAL AND
		p.CD_PROD = i.CD_PROD		
	WHERE
		p.DT_PROC > i.DT_MOV
end
GO


